/////////////////////////////////////////////////////////////
// CINEMA SDK : OPERATORS      														 //
/////////////////////////////////////////////////////////////
// VERSION    : CINEMA 4D																	 //
/////////////////////////////////////////////////////////////
// (c) 1989-2002 MAXON Computer GmbH, all rights reserved	 //
/////////////////////////////////////////////////////////////

#ifndef __C4DOPERATORDATA_H
#define __C4DOPERATORDATA_H

////////////////////////////////

#include "c4d_nodedata.h"
#include "c4d_graphview.h"

////////////////////////////////

class GvOperatorData : public NodeData
{
	public:
		////inherited from NodeData////
		virtual Bool Init(GeListNode *node);
		//virtual void Free(GeListNode *node);
		//virtual Bool Read(GeListNode *node, HyperFile *hf, LONG level);
		//virtual Bool Write(GeListNode *node, HyperFile *hf);
		//virtual Bool Message(GeListNode *node, LONG type, void *data);
		//virtual Bool CopyTo(NodeData *dest, GeListNode *snode, GeListNode *dnode, LONG flags, AliasTrans *trn);
		//static NodeData *Alloc(void) { return gNew MyNodeData; }
		virtual Bool GetDDescription(GeListNode *node, Description *description,LONG &flags);
		virtual Bool GetDParameter(GeListNode *node, const DescID &id,GeData &t_data,LONG &flags);
		virtual Bool GetDEnabling(GeListNode *node, const DescID &id,GeData &t_data,LONG flags,const BaseContainer *itemdesc);
		virtual Bool SetDParameter(GeListNode *node, const DescID &id,const GeData &t_data,LONG &flags);
		////inherited from NodeData////

		virtual void					iGetPortList(GvNode *bn, GvPortIO port, GvPortList &portlist);
		virtual Bool				  iGetPortDescription(GvNode *bn, GvPortIO port, LONG id, GvPortDescription *pd);
		virtual Bool					iCreateOperator(GvNode *bn);
		
		virtual Bool					CreatePortDescriptionCache(GvNode *bn, Bool lock_only = FALSE);
		virtual void					FreePortDescriptionCache(GvNode *bn);

		virtual const String  GetDetailedText(GvNode *bn);
		virtual const String	GetText(GvNode *bn);
		virtual const String	GetTitle(GvNode *bn);
		virtual BaseBitmap*		GetPortIcon(GvNode *bn, LONG id, GvLayoutType layout_type);
		virtual void					GetBodySize(GvNode *bn, LONG *width, LONG *height);
		virtual const Vector	GetBodyColor(GvNode *bn);
		virtual void					EditorDraw(GvNode *bn, GvNodeGUI* gui, GeUserArea *da, LONG x1, LONG y1, LONG x2, LONG y2);
		virtual Bool				  GetOperatorDescription(GvNode *bn, GvOperatorDescription *od);
		virtual Bool					QueryCalculation(GvNode *bn, GvQuery *query);
		virtual Bool					InitCalculation(GvNode *bn, GvCalc *calc, GvRun *run);
		virtual void					FreeCalculation(GvNode *bn, GvCalc *calc);
		virtual Bool					Calculate(GvNode *bn, GvPort *port, GvRun *run, GvCalc *calc);
		virtual Bool					AddToCalculationTable(GvNode *bn, GvRun *run); 
		virtual Bool					SetRecalculate(GvNode *bn, GvPort *port, GvRun *run, Bool force_set = FALSE); 
		virtual Bool					SetData(GvNode *bn, GvDataType type, void *data, GvOpSetDataMode mode = GV_OP_SET);
		virtual Bool					IsSetDataAllowed(GvNode *bn, GvDataType type, void *data, GvOpSetDataMode mode = GV_OP_SET);
		virtual LONG					FillPortMenu(GvNode *bn, BaseContainer &menu, LONG port_id, LONG first_menu_id);
		virtual Bool					PortMenuCommand(GvNode *bn, LONG menu_id, LONG port_id, LONG mx, LONG my);
		virtual LONG					FillOperatorMenu(GvNode *bn, BaseContainer &menu, LONG first_menu_id);
		virtual Bool					OperatorMenuCommand(GvNode *bn, LONG menu_id, LONG mx, LONG my);
		virtual LONG					FillPortsMenu(GvNode *bn, BaseContainer &names, BaseContainer &ids, GvValueID value_type, GvPortIO port, LONG first_menu_id);
		virtual Bool					BodyMessage(GvNode* bn, GvNodeGUI *gui, LONG x, LONG y, LONG chn, LONG qua, const BaseContainer &msg);
		virtual Bool					EditSettings(GvNode* bn, GvNodeGUI *gui);
		virtual const String  GetErrorString(GvNode *bn, LONG error);
		virtual Bool					SceneDraw(GvNode *bn, BaseDraw *bd, BaseDrawHelp *bh, BaseThread *bt, LONG flags, void *data, ULONG counter);

		virtual	LONG					GetMainID(GvNode *bn, GvPortIO io, const DescID &desc_id);
		virtual const DescID	GetDescID(GvNode *bn, GvPortIO io, LONG main_id);
};

////////////////////////////////

Bool GvRegisterOperatorPlugin(GvOperatorID id, const String &str, LONG info, DataAllocator *at, const String &description, LONG disklevel, GvOpClassID op_class, GvOpGroupID op_group, LONG op_owner, BaseBitmap *icon);

////////////////////////////////

#endif //__C4DOPERATORDATA_H 

////////////////////////////////
